<?php

namespace FiloBlu\Core\Model\ResourceModel;

use Magento\CatalogSearch\Model\ResourceModel\EngineInterface;
use Magento\Eav\Model\Entity\Attribute;

/**
 * Class Engine
 * @package FiloBlu\Core\Model\ResourceModel
 */
class Engine implements EngineInterface
{

    /**
     * @return array
     */
    public function getAllowedVisibility()
    {
        return [];
    }

    /**
     * @return bool
     */
    public function allowAdvancedIndex()
    {
        return false;
    }

    /**
     * @param Attribute $attribute
     * @param mixed $value
     * @return mixed|string
     */
    public function processAttributeValue($attribute, $value)
    {
        return '';
    }

    /**
     * @param array $index
     * @param string $separator
     * @return array|string
     */
    public function prepareEntityIndex($index, $separator = ' ')
    {
        return '';
    }

    /**
     * @return false
     */
    public function isAvailable()
    {
        return true;
    }
}
