<?php

namespace FiloBlu\Core\Model\Optimizer;

use Magento\Framework\App\ResourceConnection;

/**
 *
 */
class CmsContentProvider implements ContentProviderInterface
{

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;
    /**
     * @var string
     */
    private $tableName;
    /**
     * @var string
     */
    private $contentColumn;

    /**
     * @param \Magento\Framework\App\ResourceConnection $resourceConnection
     * @param string $tableName
     * @param string $contentColumn
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        string $tableName,
        string $contentColumn
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->tableName = $tableName;
        $this->contentColumn = $contentColumn;
    }

    /**
     * @return array
     */
    public function getContents(): array
    {
        $connection = $this->resourceConnection->getConnection();
        $select = $connection->select()->from($connection->getTableName($this->tableName), [$this->contentColumn]);
        return $connection->fetchCol($select);
    }
}
