<?php

namespace FiloBlu\Core\Model\Optimizer;

use Magento\Framework\App\ResourceConnection;

/**
 *
 */
class CmsContentModifier implements ContentModifierInterface
{

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;
    /**
     * @var string|null
     */
    private $tableName;
    /**
     * @var string|null
     */
    private $primaryKey;
    /**
     * @var string|null
     */
    private $contentColumn;

    /**
     * @param \Magento\Framework\App\ResourceConnection $resourceConnection
     * @param string $tableName
     * @param string $primaryKey
     * @param string $contentColumn
     */
    public function __construct(
        ResourceConnection $resourceConnection,
        string $tableName,
        string $primaryKey,
        string $contentColumn
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->tableName = $tableName;
        $this->primaryKey = $primaryKey;
        $this->contentColumn = $contentColumn;
    }

    /**
     * @param array $dataToReplace
     * @return void
     */
    public function updateContent(array $dataToReplace)
    {
        $connection = $this->resourceConnection->getConnection();

        $from = [];
        $to = [];
        foreach ($dataToReplace as $data) {
            $from[] = $data['from'];
            $to[] = $data['to'];
        }
        $table = $connection->getTableName($this->tableName);
        $select = $connection->select()->from($table, [$this->primaryKey, $this->contentColumn]);

        foreach ($connection->fetchPairs($select) as $id => $content) {
            $content = str_replace($from, $to, $content);
            $where = $connection->quoteInto("$this->primaryKey = ?", $id);
            $connection->update($table, [$this->contentColumn => $content], $where);
        }
    }
}
