<?php

declare(strict_types=1);

namespace FiloBlu\Core\Model\Mail;

use Magento\Framework\Mail\MessageInterface;
use Magento\Framework\Mail\TransportInterface;
use Zend\Mail\Message;

/**
 * Class NullMailer
 * @package FiloBlu\Core\Model\Mail
 */
class BlackHole implements TransportInterface
{
    /**
     * @var \Magento\Framework\Mail\MessageInterface
     */
    private $message;

    /**
     * BlackHole constructor.
     * @param MessageInterface $message
     * @param null $parameters
     */
    public function __construct(
        MessageInterface $message,
        $parameters = null
    ) {
        $this->message = $message;
    }

    /**
     * @return void
     */
    public function sendMessage()
    {
    }

    /**
     * @return \Magento\Framework\Mail\MessageInterface
     */
    public function getMessage()
    {
        return $this->message;
    }
}
