<?php

namespace FiloBlu\Core\Model\Indexer;

use Magento\Framework\Indexer\SaveHandler\IndexerInterface;
use Traversable;

/**
 * Class IndexerHandler
 * @package FiloBlu\Core\Model\Indexer
 */
class IndexerHandler implements IndexerInterface
{
    /**
     * @var array
     */
    protected $data;

    /**
     * IndexerHandler constructor.
     * @param array $data
     */
    public function __construct(
        array $data = []
    ) {
        $this->data = $data;
    }

    /**
     * @inheritdoc
     */
    public function saveIndex($dimensions, Traversable $documents)
    {
        return $this;
    }

    /**
     * @inheritdoc
     */
    public function deleteIndex($dimensions, Traversable $documents)
    {
        return $this;
    }

    /**
     * @inheritdoc
     */
    public function cleanIndex($dimensions)
    {
        return $this;
    }

    /**
     * @inheritdoc
     */
    public function isAvailable($dimensions = [])
    {
        return true;
    }
}
