<?php
declare(strict_types=1);

namespace FiloBlu\Core\Model;

use FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface;
use Magento\Framework\DataObject;

class FbOrderExtensionAttr extends DataObject implements FbOrderExtensionAttrInterface
{

    /**
     * {@inheritdoc}
     */
    public function getFborderextensionattrId()
    {
        return $this->getData(self::FBORDEREXTENSIONATTR_ID);
    }

    /**
     * {@inheritdoc}
     */
    public function setFborderextensionattrId($fborderextensionattrId)
    {
        return $this->setData(self::FBORDEREXTENSIONATTR_ID, $fborderextensionattrId);
    }

    /**
     * {@inheritdoc}
     */
    public function getOrderId()
    {
        return $this->getData(self::ORDER_ID);
    }

    /**
     * {@inheritdoc}
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    /**
     * {@inheritdoc}
     */
    public function getPreprintedRmaTrackingCode()
    {
        return $this->getData(self::PREPRINTED_RMA_TRACKING_CODE);
    }

    /**
     * {@inheritdoc}
     */
    public function setPreprintedRmaTrackingCode($preprintedRmaTrackingCode)
    {
        return $this->setData(self::PREPRINTED_RMA_TRACKING_CODE, $preprintedRmaTrackingCode);
    }

    /**
     * {@inheritdoc}
     */
    public function getShippingDocumentUrl(){
        return $this->getData(self::SHIPPING_DOCUMENT_URL);
    }

    /**
     * {@inheritdoc}
     */
    public function getShippingDocumentPayload(){
        return $this->getData(self::SHIPPING_DOCUMENT_PAYLOAD);
    }

    /**
     * {@inheritdoc}
     */
    public function setShippingDocumentUrl($url){
        return $this->setData(self::SHIPPING_DOCUMENT_URL, $url);
    }

    /**
     * {@inheritdoc}
     */
    public function setShippingDocumentPayload($payload){
        return $this->setData(self::SHIPPING_DOCUMENT_PAYLOAD, $payload);
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->getData(self::FBORDEREXTENSIONATTR_ID);
    }

    public function setId($id)
    {
        $this->setData(self::FBORDEREXTENSIONATTR_ID, $id);
        return $this;
    }
}

