<?php
declare(strict_types=1);

namespace FiloBlu\Core\Model\Eav;

use FiloBlu\Core\Helper\Delivery\CustomerAddressFieldHelper;
use Magento\Eav\Model\Entity\Attribute\AbstractAttribute;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Exception\LocalizedException;

class Config extends \Magento\Eav\Model\Config
{
    /**
     * @var CustomerAddressFieldHelper
     */
    private $addressFieldHelper;


    /**
     * Customization of method getAttribute to pass dynamically
     * is required field based on configurations
     * @param $entityType
     * @param $code
     * @return AbstractAttribute|null
     * @throws LocalizedException
     */
    public function getAttribute($entityType, $code)
    {
        $attributeToCheck = parent::getAttribute($entityType, $code);
        return $this->getAddressFieldHelper()->checkAttribute($attributeToCheck);
    }

    public function getAddressFieldHelper()
    {
        if ($this->addressFieldHelper == null) {
            $this->addressFieldHelper = ObjectManager::getInstance()->get(CustomerAddressFieldHelper::class);
        }

        return $this->addressFieldHelper;
    }
}
