<?php

namespace FiloBlu\Core\Model\Config\Source;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\SalesRule\Model\RuleRepository;

class SalesRule implements OptionSourceInterface
{

    /**
     * @var RuleRepository
     */
    private $ruleRepository;
    /**
     * @var SearchCriteriaBuilder
     */
    private $criteriaBuilder;

    public function __construct(
        RuleRepository        $ruleRepository,
        SearchCriteriaBuilder $criteriaBuilder
    )
    {
        $this->ruleRepository = $ruleRepository;
        $this->criteriaBuilder = $criteriaBuilder;
    }

    /**
     * @throws LocalizedException
     */
    public function toOptionArray()
    {
        $searchCriteria = $this->criteriaBuilder->create();
        $salesRules = $this->ruleRepository->getList($searchCriteria);

        $optionArray = [];
        foreach ($salesRules->getItems() as $rule)
        {
            $optionArray[] = ['label' => $rule->getName(), 'value' => $rule->getRuleId()];
        }
        return $optionArray;
    }
}
