<?php

namespace FiloBlu\Core\Model\Config\Source;

use Magento\Customer\Model\Customer;
use Magento\Framework\Data\OptionSourceInterface;

class CustomerAttributes implements OptionSourceInterface
{

    /**
     * @var Customer
     */
    private $customer;

    public function __construct(
        Customer $customer
    ){
        $this->customer = $customer;
    }

    /**
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function toOptionArray()
    {
        $customerAttributes = $this->customer->getAttributes();
        $attributeArray = [];

        foreach($customerAttributes as $cal=>$val){
            $attributeArray[] = array(
                'label' => $cal,
                'value' => $cal
            );
        }

        return $attributeArray;
    }
}
