<?php
declare(strict_types=1);

namespace FiloBlu\Core\Model\Config\Source;

use Magento\Customer\Api\AddressMetadataInterface;
use Magento\Framework\Data\OptionSourceInterface;

class CustomerAddressFields implements OptionSourceInterface
{
    /**
     * @var AddressMetadataInterface
     */
    protected $addressMetadata;

    /**
     * Constructor
     *
     * @param AddressMetadataInterface $addressMetadata
     */
    public function __construct(
        AddressMetadataInterface $addressMetadata
    ) {
        $this->addressMetadata = $addressMetadata;
    }

    /**
     * Get list of required customer address fields
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];
        try {
            $attributes = $this->addressMetadata->getAllAttributesMetadata();
            foreach ($attributes as $attribute) {
                if ($attribute->isRequired()) {
                    $options[] = [
                        'value' => $attribute->getAttributeCode(),
                        'label' => __($attribute->getFrontendLabel())
                    ];
                }
            }
        } catch (\Exception $e) {
            // TODO HANDLE POSSIBLE EXCEPTION
        }

        return $options;
    }
}
