<?php
declare(strict_types=1);

namespace FiloBlu\Core\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Shipping\Model\CarrierFactory;

class Carriers implements OptionSourceInterface
{
    /**
     * Core store config
     *
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * @var \Magento\Shipping\Model\Config
     */
    protected $_shippingConfig;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Shipping\Model\Config $shippingConfig
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Shipping\Model\Config                     $shippingConfig
    )
    {
        $this->_scopeConfig = $scopeConfig;
        $this->_shippingConfig = $shippingConfig;
    }

    /**
     * Get available shipping carriers
     *
     * @return array
     */
    public function toOptionArray()
    {
        $carriers = [];
        $carrierInstances = $this->_shippingConfig->getAllCarriers();

        foreach ($carrierInstances as $carrierCode => $carrierModel) {
            $carriers[] = [
                'value' => $carrierCode,
                'label' => $carrierCode
            ];
        }
        return $carriers;
    }
}
