<?php
declare(strict_types=1);
namespace FiloBlu\Core\Model\Config\Backend;

use Magento\Framework\App\Config\Value;

class ValidateCarriers extends Value
{
    /**
     * Perform validation before saving configuration data
     *
     * @return $this
     * @throws \Magento\Framework\Exception\ValidatorException
     */
    public function beforeSave()
    {
        $carriers = $this->getValue();

        if (is_array($carriers)) {
            // Esempio di validazione: controlla che almeno un carrier sia selezionato
            if (empty($carriers)) {
                throw new \Magento\Framework\Exception\ValidatorException(__('You must select at least one carrier.'));
            }
        }

        return parent::beforeSave();
    }
}
