<?php
declare(strict_types=1);

namespace FiloBlu\Core\Helper;

use Magento\Framework\UrlInterface;

/**
 *
 */
class Url
{
    /**
     * @var UrlInterface
     */
    private $url;

    /**
     * @param UrlInterface $url
     */
    public function __construct(UrlInterface $url)
    {
        $this->url = $url;
    }

    /**
     * @param $url
     * @return string
     */
    public function replaceWithAdminDomain($url)
    {
        return $this->replaceDomain($url, $this->getAdminDomain());
    }

    /**
     * @param $url
     * @param $withDomain
     * @return string
     */
    public function replaceDomain($url, $withDomain)
    {
        return str_replace($this->getHostname($url), $withDomain, $url);
    }

    /**
     * @param $url
     * @return string|false
     */
    public function getHostname($url)
    {
        return parse_url($url, PHP_URL_HOST);
    }

    /**
     * @return false|string
     */
    public function getAdminDomain()
    {
        return $this->getHostname($this->url->setScope(0)->getBaseUrl());
    }
}
