<?php
declare(strict_types=1);



namespace FiloBlu\Core\Framework\Model;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Interface RepositoryInterface
 * @package FiloBlu\Esb\Api
 */
interface RepositoryInterface
{
    /**
     * @param int $id
     * @return void
     */
    public function deleteById($id);

    /**
     * @param int $id
     * @return RepositoryItem
     * @throws NoSuchEntityException
     */
    public function getById($id): RepositoryItem;

    /**
 * @param SearchCriteriaInterface $searchCriteria
 * @param bool $asArray
 * @return SearchResultsInterface
 */
    public function getList(SearchCriteriaInterface $searchCriteria, $asArray = false): SearchResultsInterface;

    /**
     * @param SearchCriteriaInterface|null $searchCriteria
     * @param bool $ignoreLimit if true ignores pagination and limit in search criteria
     * @return int
     */
    public function count(SearchCriteriaInterface $searchCriteria = null, $ignoreLimit = false): int;
}
