<?php

namespace FiloBlu\Core\Framework\Model\Mail;

use FiloBlu\Core\Framework\Model\DataSetInterface;

/**
 * Interface MessageInterface
 * @package FiloBlu\Core\Framework\Model\Mail
 */
interface MessageInterface extends DataSetInterface
{
    /** @var string */
    const FROM = 'from';
    /** @var string */
    const TO = 'to';
    /** @var string */
    const STORE_ID = 'store_id';
    /** @var string */
    const REPLY_TO = 'reply_to';
    /** @var string */
    const BCC = 'bcc';
    /** @var string */
    const CC = 'cc';
    /** @var string */
    const EMAIL_TEMPLATE = 'template';
    /** @var string */
    const EMAIL_TEMPLATE_VARIABLES = 'template_variables';
    /** @var string */
    const EMAIL_TEMPLATE_OPTIONS = 'template_options';
    /** @var string */
    const ENABLE_TRANSLATION = 'enable_translations';
    /** @var string */
    const ATTACHMENTS = 'attachments';

    /**
     * @return string|array|null
     */
    public function getFrom();

    /**
     * @return array
     */
    public function getTo(): array;

    /**
     * @return string|null
     */
    public function getReplyTo();

    /**
     * @return array
     */
    public function getBcc(): array;

    /**
     * @return array
     */
    public function getCc(): array;

    /**
     * @param string|array $from
     * @return MessageInterface
     */
    public function setFrom($from): MessageInterface;

    /**
     * @param string|string[] $to
     *
     * @return MessageInterface
     */
    public function setTo($to): MessageInterface;

    /**
     * @param string $replyTo
     * @return MessageInterface
     */
    public function setReplyTo(string $replyTo = null): MessageInterface;

    /**
     * @param $bcc
     * @return MessageInterface
     */
    public function setBcc(array $bcc): MessageInterface;

    /**
     * @param $cc
     * @return MessageInterface
     */
    public function setCc(array $cc): MessageInterface;

    /**
     * @param string|string[] $to
     * @return MessageInterface
     */
    public function addTo($to): MessageInterface;

    /**
     * @return int
     */
    public function getStoreId();

    /**
     * @param $storeId
     * @return MessageInterface
     */
    public function setStoreId($storeId): MessageInterface;

    /**
     * @param $template
     * @return mixed
     */
    public function setTemplate($template): MessageInterface;

    /**
     * @return mixed
     */
    public function getTemplate();

    /**
     * @param array $variables
     * @return mixed
     */
    public function setTemplateVariables(array $variables): MessageInterface;

    /**
     * @return mixed
     */
    public function getTemplateVariables();

    /**
     * @param array $options
     * @return mixed
     */
    public function setTemplateOptions(array $options): MessageInterface;

    /**
     * @return array
     */
    public function getTemplateOptions() : array;

    /**
     * @return mixed
     */
    public function enableTranslation(bool $enable): MessageInterface;

    /**
     * @return mixed
     */
    public function canTranslate(): bool;

    /**
     * @param $filePath
     * @param null $name
     * @return mixed
     */
    public function setAttachments(array $attachments): MessageInterface;

    /**
     * @return mixed
     */
    public function getAttachments(): array;
}
