<?php

namespace FiloBlu\Core\Framework\Model\Mail;

use FiloBlu\Core\Framework\Model\DataSet;

/**
 * Class Message
 * @package FiloBlu\Core\Framework\Model\Mail
 */
class Message extends DataSet implements MessageInterface
{
    /**
     * @return string|array|null
     */
    public function getFrom()
    {
        return $this->getData(self::FROM);
    }

    /**
     * @param string|array $from
     * @return $this|MessageInterface
     */
    public function setFrom($from): MessageInterface
    {
        $this->setData(self::FROM, $from);
        return $this;
    }


    /**
     * @param $replyTo
     * @return $this|MessageInterface
     */
    public function setReplyTo(string $replyTo = null): MessageInterface
    {
        $this->setData(self::REPLY_TO, $replyTo);
        return $this;
    }


    /**
     * @param string|string[] $to
     * @return $this|mixed
     */
    public function setTo($to): MessageInterface
    {
        if (!(is_array($to) || is_string($to))) {
            return $this;
        }

        if (is_string($to)) {
            $this->setData(self::TO, [$to]);
            return $this;
        }

        $this->setData(self::TO, $to);
        return $this;
    }

    /**
     * @param string|array $to
     * @return $this|mixed
     */
    public function addTo($to): MessageInterface
    {
        if (!(is_array($to) || is_string($to))) {
            return $this;
        }

        $oldTo = $this->getTo();

        if (is_string($to)) {
            $to = [$to];
        }

        $this->setData(self::TO, array_merge($oldTo, $to));
        return $this;
    }

    /**
     * @return array|mixed|null
     */
    public function getTo(): array
    {
        return $this->getData(self::TO) ?? [];
    }

    /**
     * @return array|int|mixed|null
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * @param $storeId
     * @return $this|MessageInterface
     */
    public function setStoreId($storeId): MessageInterface
    {
        $this->setData(self::STORE_ID, $storeId);
        return $this;
    }

    /**
     * @param $template
     * @return $this|mixed
     */
    public function setTemplate($template): MessageInterface
    {
        $this->setData(self::EMAIL_TEMPLATE, $template);
        return $this;
    }

    /**
     * @return Message|mixed
     */
    public function getTemplate()
    {
        return $this->getData(self::EMAIL_TEMPLATE);
    }

    /**
     * @param $variables
     * @return $this|MessageInterface
     */
    public function setTemplateVariables(array $variables): MessageInterface
    {
        $this->setData(self::EMAIL_TEMPLATE_VARIABLES, $variables);
        return $this;
    }

    /**
     * @return Message|mixed
     */
    public function getTemplateVariables()
    {
        return $this->getData(self::EMAIL_TEMPLATE_VARIABLES) ?? [];
    }

    /**
     * @param $options
     * @return $this|MessageInterface
     */
    public function setTemplateOptions(array $options): MessageInterface
    {
        $this->setData(self::EMAIL_TEMPLATE_OPTIONS, $options);
        return $this;
    }

    /**
     * @return array
     */
    public function getTemplateOptions(): array
    {
        return $this->getData(self::EMAIL_TEMPLATE_OPTIONS) ?? [];
    }


    /**
     * @param $bcc
     * @return $this|MessageInterface
     */
    public function setBcc(array $bcc): MessageInterface
    {
        $this->setData(self::BCC, $bcc);
        return $this;
    }

    /**
     * @param $cc
     * @return MessageInterface
     */
    public function setCc(array $cc): MessageInterface
    {
        $this->setData(self::CC, $cc);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getReplyTo()
    {
        return $this->getData(self::REPLY_TO);
    }

    /**
     * @return array
     */
    public function getBcc(): array
    {
        return $this->getData(self::BCC) ?? [];
    }

    /**
     * @return array
     */
    public function getCc(): array
    {
        return $this->getData(self::CC) ?? [];
    }

    /**
     * @param bool $enable
     * @return MessageInterface
     */
    public function enableTranslation(bool $enable): MessageInterface
    {
        $this->setData(self::ENABLE_TRANSLATION, $enable);
        return $this;
    }

    /**
     * @return bool
     */
    public function canTranslate(): bool
    {
        return (bool)$this->getData(self::ENABLE_TRANSLATION);
    }

    /**
     * @param array $attachments
     * @return $this|mixed
     */
    public function setAttachments(array $attachments): MessageInterface
    {
        $this->setData(self::ATTACHMENTS, $attachments);
        return $this;
    }

    /**
     * @return array
     */
    public function getAttachments(): array
    {
        return $this->getData(self::ATTACHMENTS) ?? [];
    }

}
