<?php

namespace FiloBlu\Core\Framework\Model;

use Magento\Framework\DataObject;
use Magento\Framework\ObjectManager\NoninterceptableInterface;

/**
 * Class DataSet
 * @package FiloBlu\Core\Model
 */
class DataSet extends DataObject implements DataSetInterface
{
    /**
     * @param string $path
     * @param $value
     * @return $this|DataSetInterface
     */
    public function setDataByPath($path, $value)
    {
        $data = &$this->_data;

        if (!is_array($path)) {
            $path = explode('/', $path);
        }

        $key = array_pop($path);

        foreach ($path as $k) {
            if (!isset($data[$k])) {
                $data[$k] = [];
            }
            $data = &$data[$k];
        }
        $data[$key ? $key : count($data)] = $value;
        return $this;
    }

    /**
     * @param array $keys
     * @return array
     */
    public function toArray(array $keys = [])
    {
        if (empty($keys)) {
            return $this->_data;
        }

        $result = [];
        foreach ($keys as $key) {
            if (isset($this->_data[$key])) {
                if ($this->_data[$key] instanceof DataObject) {
                    $result[$key] = $this->_data[$key]->toArray();
                } else {
                    $result[$key] = $this->_data[$key];
                }
            } else {
                $result[$key] = null;
            }
        }
        return $result;
    }
}
