<?php
declare(strict_types=1);

namespace FiloBlu\Core\Controller\Adminhtml\System;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Area;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\MailException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;
use Throwable;

/**
 *
 */
class Send extends Action
{
    /** @var TransportBuilder */
    protected $transportBuilder;
    /** @var StoreManagerInterface */
    protected $storeManager;
    /** @var StateInterface */
    protected $inlineTranslation;
    /** @var ScopeConfigInterface */
    private $scopeConfig;

    /**
     * @param Context $context
     * @param TransportBuilder $transportBuilder
     * @param StoreManagerInterface $storeManager
     * @param StateInterface $state
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Context               $context,
        TransportBuilder      $transportBuilder,
        StoreManagerInterface $storeManager,
        StateInterface        $state,
        ScopeConfigInterface  $scopeConfig
    )
    {
        parent::__construct($context);

        $this->transportBuilder = $transportBuilder;
        $this->storeManager = $storeManager;
        $this->inlineTranslation = $state;
        $this->scopeConfig = $scopeConfig;
    }

    public function execute()
    {
        $to = $this->getRequest()->getParam('to');
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        try {
            $this->sendEmail($to);
            $response->setHttpResponseCode(200);
            $response->setData(['message' => 'Mail successfully sent']);
        } catch (Throwable $throwable) {
            $response->setHttpResponseCode(500);
            $response->setData(['message' => 'Unable to send email: ' . $throwable->getMessage()]);
        }

        return $response;
    }

    /**
     * @throws NoSuchEntityException
     * @throws MailException
     */
    public function sendEmail($to)
    {
        $now = (new \DateTime())->format('Y-m-d H:i:s');
        $templateId = 'filoblu_core_plain_frontend_template';
        $templateVars = [
            'subject' => "FiloBlu Core Test Email, {$now}",
            'message' => '<center><h1>It works! 🥳</h1></center>'
        ];

        $storeId = $this->storeManager->getStore()->getId();

        $fromEmail = $this->scopeConfig->getValue(
            'trans_email/ident_sales/email',
            ScopeInterface::SCOPE_STORE
        );

        $from = [
            'email' => $fromEmail,
            'name'  => 'FiloBlu Email Tester'
        ];

        $this->inlineTranslation->suspend();

        $templateOptions = [
            'area'  => Area::AREA_FRONTEND,
            'store' => $storeId
        ];
        $transport = $this->transportBuilder
            ->setTemplateIdentifier($templateId)
            ->setTemplateOptions($templateOptions)
            ->setTemplateVars($templateVars)
            ->setFrom($from)
            ->addTo($to)
            ->getTransport();
        $transport->sendMessage();
        $this->inlineTranslation->resume();
    }

}