<?php

namespace FiloBlu\Core\Console\Command;

use FiloBlu\Core\Helper\WysiwygOptimizer;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;


/**
 *
 */
class WysiwygImageDirOptimizer extends Command
{
    const NAME = 'name';
    /**
     * @var WysiwygOptimizer
     */
    private $wysiwygOptimizer;

    /**
     * @param string|null $name The name of the command; passing null means it must be set in configure()
     *
     * @throws LogicException When the command name is empty
     */
    public function __construct(
        WysiwygOptimizer $wysiwygOptimizer,
        $name = null
    ) {
        $this->wysiwygOptimizer = $wysiwygOptimizer;
        parent::__construct($name);
    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $exitCode = 0;
        $output->writeln('<comment>Checking...</comment>');

        try {
            $output->writeln('<comment>Parsing CMS...</comment>');
            $fileList = $this->wysiwygOptimizer->getUsedImages();

            $output->writeln('<comment>Generating list of file to be moved...</comment>');
            $toBeMovedList = $this->wysiwygOptimizer->checkFiles($fileList);

            $output->writeln('<comment>Fixing duplicated images on contents...</comment>');
            $this->wysiwygOptimizer->fixDuplicatedContentImage($toBeMovedList);

            $output->writeln('<comment>Moving files to backup folder...</comment>');
            $this->wysiwygOptimizer->moveFiles($toBeMovedList);
        } catch (Exception $e) {
            $output->writeln(
                sprintf(
                    '<error>%s</error>',
                    $e->getMessage()
                )
            );
            $exitCode = 1;
        }

        $output->writeln('$$$$$$$$\ $$\        $$$$$$\  $$\      $$\ $$$$$$$\  $$$$$$$$\       $$\
$$  _____|$$ |      $$  __$$\ $$$\    $$$ |$$  __$$\ $$  _____|      $$ |
$$ |      $$ |      $$ /  $$ |$$$$\  $$$$ |$$ |  $$ |$$ |            $$ |
$$$$$\    $$ |      $$$$$$$$ |$$\$$\$$ $$ |$$$$$$$\ |$$$$$\          $$ |
$$  __|   $$ |      $$  __$$ |$$ \$$$  $$ |$$  __$$\ $$  __|         \__|
$$ |      $$ |      $$ |  $$ |$$ |\$  /$$ |$$ |  $$ |$$ |
$$ |      $$$$$$$$\ $$ |  $$ |$$ | \_/ $$ |$$$$$$$  |$$$$$$$$\       $$\
\__|      \________|\__|  \__|\__|     \__|\_______/ \________|      \__|');
        return $exitCode;
    }

    protected function configure()
    {
        $this->setName('filoblu:wysiwyg:optimize:dir');
        $this->setDescription(
            'Move unused or duplicated images into a backup folder'
        );
        $this->addOption(
            self::NAME,
            null,
            InputOption::VALUE_REQUIRED,
            'Name'
        );
        parent::configure();
    }
}
