<?php
declare(strict_types=1);

namespace FiloBlu\Core\Block\System\Config\Form\Field;

use Magento\Framework\View\Element\Context;
use Magento\Framework\View\Element\Html\Select;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class WebsiteMultiselect
 * @package FiloBlu\Core\Block\System\Config\Form\Field
 */
class WebsiteMultiselect extends Select
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * WebsiteMultiselect constructor.
     * @param Context $context
     * @param StoreManagerInterface $storeManager
     * @param array $data
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        array $data = []
    )
    {
        parent::__construct($context, $data);
        $this->storeManager = $storeManager;
    }

    /**
     * @param $value
     * @return mixed
     */
    public function setInputName($value)
    {
        return $this->setName($value . '[]');
    }

    /**
     * @return string
     */
    public function _toHtml()
    {
        if (!$this->getOptions()) {

            $options = [];

            foreach ($this->storeManager->getWebsites() as $website) {
                $options[] = [
                    'label' => $website->getCode(),
                    'value' => $website->getCode()
                ];
            }

            $this->setOptions($options);
        }

        $this->setExtraParams('multiple="multiple"');
        return parent::_toHtml();
    }

}
