<?php

namespace FiloBlu\Core\Block\System\Config\Form\Field;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\View\Element\Html\Select;

/**
 * Class DynamicSmtp
 * @package FiloBlu\Core\Block\System\Config\Form\Field
 */
class DynamicSmtp extends AbstractFieldArray
{
    /**
     * @var \FiloBlu\Core\Model\Config\Source\Ssl
     */
    private $sslOption;
    /**
     * @var \FiloBlu\Core\Model\Config\Source\ConnectionClasses
     */
    private $connectClass;

    /**
     * DynamicSmtp constructor.
     * @param Context $context
     * @param \FiloBlu\Core\Model\Config\Source\Ssl $sslOption
     * @param \FiloBlu\Core\Model\Config\Source\ConnectionClasses $connectClass
     * @param array $data
     */
    public function __construct(Context $context,
                                \FiloBlu\Core\Model\Config\Source\Ssl $sslOption,
                                \FiloBlu\Core\Model\Config\Source\ConnectionClasses $connectClass,
                                array $data = []
                                )
    {
        parent::__construct($context, $data);
        $this->sslOption = $sslOption;
        $this->connectClass = $connectClass;
    }

    /**
     * Prepare to render.
     *
     * @return void
     */
    protected function _prepareToRender()
    {
        $this->addColumn('from', ['label' => __('From Email')]);
        $this->addColumn('host', ['label' => __('Host')]);
        $this->addColumn('username', ['label' => __('Username')]);
        $this->addColumn('password', ['label' => __('Password')]);
        $this->addColumn('port', ['label' => __('Port')]);
        $this->addColumn('ssl', [
            'renderer' =>
                $this->getLayout()
                    ->createBlock(Select::class)
                    ->setId($this->_getCellInputElementId('<%- _id %>', 'ssl'))
                    ->setName($this->_getCellInputElementName('ssl'))
                    ->setClass('select')
                    ->setOptions($this->sslOption->toOptionArray()),

            'label' => __('Tls')
        ]);
        $this->addColumn('login', [
            'renderer' =>
                $this->getLayout()
                    ->createBlock(Select::class)
                    ->setId($this->_getCellInputElementId('<%- _id %>', 'login'))
                    ->setName($this->_getCellInputElementName('login'))
                    ->setClass('select')
                    ->setOptions($this->connectClass->toOptionArray()),

            'label' => __('Login')
        ]);

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }


    public function render(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $isCheckboxRequired = $this->_isInheritCheckboxRequired($element);

        // Disable element if value is inherited from other scope. Flag has to be set before the value is rendered.
        if ($element->getInherit() == 1 && $isCheckboxRequired) {
            $element->setDisabled(true);
        }

        if ($element->getIsDisableInheritance()) {
            $element->setReadonly(true);
        }

     /*   $html = '<td class="label"><label for="' .
            $element->getHtmlId() . '"><span' .
            $this->_renderScopeLabel($element) . '>' .
            $element->getLabel() .
            '</span></label></td>';*/
        $html = $this->_renderValue($element);

        if ($isCheckboxRequired) {
            $html .= $this->_renderInheritCheckbox($element);
        }

        $html .= $this->_renderHint($element);

        return $this->_decorateRowHtml($element, $html);
    }
}
