<?php

namespace FiloBlu\Core\Block\Adminhtml\Buttons;

use FiloBlu\Core\Block\Adminhtml\Buttons\Common\Button;

class DeleteButton extends Button
{

    public function getButtonData(): array
    {
        if ($this->getId() === null) {
            return [];
        }

        return [
            'label' => __('Delete'),
            'class' => 'delete action-secondary',
            'on_click' => 'deleteConfirm(\''
                . __('Are you sure you want to delete this event ?')
                . '\', \'' . $this->getUrl('*/*/delete', ['id' => $this->getId()]) . '\')',
            'sort_order' => 20,
        ];
    }

    /**
     * @return string|null
     */
    protected function getId()
    {
        return $this->context->getRequest()->getParam('id', null);
    }
}
