<?php

namespace FiloBlu\Core\Block\Adminhtml\Buttons\Common;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Model\Url;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class Button
 * @package FiloBlu\Core\Block\Adminhtml\Common
 */
abstract class Button implements ButtonProviderInterface
{
    /**
     * @var Context
     */
    protected $context;
    /**
     * @var Url
     */
    private $url;

    /**
     * @param Context $context
     * @param Url $url
     */
    public function __construct(
        Context $context,
        Url $url
    ) {
        $this->context = $context;
        $this->url = $url;
    }

    /**
     * Generate url by route and parameters
     *
     * @param string $route
     * @param array $params
     * @return  string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->url->getUrl($route, $params);
    }
}
