<?php
namespace FiloBlu\Core\Block\Adminhtml\Buttons;

use FiloBlu\Core\Block\Adminhtml\Buttons\Common\Button;

class BackButton extends Button
{

    public function getButtonData(): array
    {
        return [
            'label' => __('Back'),
            'on_click' => sprintf("location.href = '%s';", $this->getUrl('*/*/', [])),
            'class' => 'back',
            'sort_order' => 10
        ];
    }
}
