<?php

namespace FiloBlu\Core\Api;

use Magento\Framework\Exception\NoSuchEntityException;
use FiloBlu\Core\Api\StoreCalculatorInterface;
use Magento\Store\Api\Data\StoreInterface;

interface StoreCalculatorResolverInterface
{

    /**
     * @return mixed
     */
    public function getAll();

    /**
     * @param string $name
     * @return \FiloBlu\Core\Api\StoreCalculatorInterface
     */
    public function get(string $name): StoreCalculatorInterface;

    /**
     * @return \FiloBlu\Core\Api\StoreCalculatorInterface
     */
    public function getDefault() : StoreCalculatorInterface;

    /**
     * @param $object
     * @return \Magento\Store\Api\Data\StoreInterface
     */
    public function resolve($object) : StoreInterface;
}
