<?php
declare(strict_types=1);

namespace FiloBlu\Core\Api;

use FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface;
use FiloBlu\Core\Framework\Model\RepositoryInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;

interface FbOrderExtensionAttrRepositoryInterface extends RepositoryInterface
{

    /**
     * Save FbOrderExtensionAttr
     * @param FbOrderExtensionAttrInterface $fbOrderExtensionAttr
     * @return FbOrderExtensionAttrInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        FbOrderExtensionAttrInterface $fbOrderExtensionAttr
    );

    /**
     * Retrieve FbOrderExtensionAttr
     * @param string $fborderextensionattrId
     * @return FbOrderExtensionAttrInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($fborderextensionattrId);

    /**
     * Retrieve FbOrderExtensionAttr matching the specified criteria.
     * @param SearchCriteriaInterface $searchCriteria
     * @return \FiloBlu\Core\Api\Data\FbOrderExtensionAttrSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria, $asArray = false): SearchResultsInterface;

    /**
     * Retrieve FbOrderExtensionAttr by order_id
     * @param string $fborderextensionattrId
     * @return FbOrderExtensionAttrInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getByOrderId($orderId);

    /**
     * Delete FbOrderExtensionAttr
     * @param FbOrderExtensionAttrInterface $fbOrderExtensionAttr
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        FbOrderExtensionAttrInterface $fbOrderExtensionAttr
    );

    /**
     * Delete FbOrderExtensionAttr by ID
     * @param string $fborderextensionattrId
     * @return void
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($fborderextensionattrId);
}

