<?php
declare(strict_types=1);

namespace FiloBlu\Core\Api\Data;

interface FbOrderExtensionAttrInterface
{

    const FBORDEREXTENSIONATTR_ID = 'fborderextensionattr_id';
    const ORDER_ID = 'order_id';
    const PREPRINTED_RMA_TRACKING_CODE = 'preprinted_rma_tracking_code';
    const SHIPPING_DOCUMENT_URL = 'shipping_document_url';
    const SHIPPING_DOCUMENT_PAYLOAD = 'shipping_document_payload';

    /**
     * Get fborderextensionattr_id
     * @return string|null
     */
    public function getFborderextensionattrId();

    /**
     * Set fborderextensionattr_id
     * @param string $fborderextensionattrId
     * @return \FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface
     */
    public function setFborderextensionattrId($fborderextensionattrId);

    /**
     * Get order_id
     * @return string|null
     */
    public function getOrderId();

    /**
     * Set order_id
     * @param string $orderId
     * @return \FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface
     */
    public function setOrderId($orderId);

    /**
     * Get preprinted_rma_tracking_code
     * @return string|null
     */
    public function getPreprintedRmaTrackingCode();

    /**
     * Set preprinted_rma_tracking_code
     * @param string $preprintedRmaTrackingCode
     * @return \FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface
     */
    public function setPreprintedRmaTrackingCode($preprintedRmaTrackingCode);

    /**
     * Get shipping_document_url
     * @return string|null
     */
    public function getShippingDocumentUrl();

    /**
     * Get shipping_document_payload
     * @return string|null
     */
    public function getShippingDocumentPayload();

    /**
     * Set shipping_document_url
     * @param string $url
     * @return \FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface
     */
    public function setShippingDocumentUrl($url);

    /**
     * Set shipping_document_payload
     * @param string $payload
     * @return \FiloBlu\Core\Api\Data\FbOrderExtensionAttrInterface
     */
    public function setShippingDocumentPayload($payload);

    /**
     * @return mixed
     */
    public function getId();

    /**
     * @param $id
     * @return mixed
     */
    public function setId($id);


}

