define([
    'jquery',
    'uiComponent',
    'domReady!'
], function ($, Component) {
    'use strict';

    return Component.extend({
        initialize: function () {
            this._super();
            $(document).ready(function () {

                function updateSocialSecurityField() {
                    const countryValue = $('[name="country_id"]').val();
                    const socialSecurityField = $('[name="shippingAddress.custom_attributes.tax_id_ssn"]');

                    if (countryValue === 'US' || countryValue === 'MX') {
                        socialSecurityField.closest('.field').show();
                        socialSecurityField.addClass('_required');
                    } else {
                        socialSecurityField.closest('.field').hide();
                        socialSecurityField.removeClass('_required');
                    }
                }

                // used this since on page load the field get filled without triggering any event
                let previousValue = '';
                setInterval(function () {
                    const currentValue = $('select[name="country_id"]').val();
                    if (currentValue !== '' && currentValue !== previousValue) {
                        updateSocialSecurityField();
                        previousValue = currentValue;
                    }
                }, 500);

                updateSocialSecurityField();

                $('[name="country_id"]').trigger('change');

                // update tax-number number in invoice form
                $(document).on('input', '[name="shippingAddress.custom_attributes.tax_id_ssn"]', function () {
                    var taxIdSsn = $(this).find('input[name="custom_attributes[tax_id_ssn]"]').val();
                    $('div[name="billingAddress.custom_attributes.checkout_invoice"] input[name="vat-number"]').val(taxIdSsn);
                });
            });
        }
    });
});