define([
    'underscore',
    'ko',
    'mageUtils',
    'uiComponent',
    'uiLayout',
    'Magento_Customer/js/model/address-list'
], function (_, ko, utils, Component, layout, addressList) {
    'use strict';

    var defaultRendererTemplate = {
        parent: '${ $.$data.parentName }',
        name: '${ $.$data.name }',
        component: 'Magento_Checkout/js/view/shipping-address/address-renderer/default'
    };

    var mixin = {

      createRendererComponent: function (address, index) {
          if (window.checkoutConfig.enabled_different_shipping_country && !window.checkoutConfig.allow_shipping.includes(address.countryId)) {
              return;
          }

          if (index in this.rendererComponents) {
              this.rendererComponents[index].address(address);
          } else {
              // rendererTemplates are provided via layout
              var rendererTemplate = (address.getType() != undefined && this.rendererTemplates[address.getType()] != undefined)
                  ? utils.extend({}, defaultRendererTemplate, this.rendererTemplates[address.getType()])
                  : defaultRendererTemplate;
              var templateData = {
                  parentName: this.name,
                  name: index
              };
              var rendererComponent = utils.template(rendererTemplate, templateData);
              utils.extend(rendererComponent, {address: ko.observable(address)});
              layout([rendererComponent]);
              this.rendererComponents[index] = rendererComponent;
          }
      }
    };

    return function (target) { // target == Result that Magento_Ui/.../default returns.
      return target.extend(mixin); // new result that all other modules receive
    };
});
