define(
        [
            'jquery',
            'Magento_Customer/js/model/customer',
            'Magento_Checkout/js/model/quote',
            'Magento_Checkout/js/model/url-builder',
            'mage/url',
            'Magento_Checkout/js/model/error-processor'
        ],
        function ($, customer, quote, urlBuilder, urlFormatter, errorProcessor) {
            'use strict';
            return {
                /**
                 * Validate something
                 *
                 * @returns {boolean}
                 */
                validate: function () {

                    var result = true;

                    if ($("input[name='custom_attributes[checkout_invoice]']").is(":checked")) {
                        $("#co-payment-form").validation();
                        var fiscalCodeValid = $('#fiscal-code').valid();
                        var vatNumberValid = $('#vat-number').valid();
                        var pecValid = $('#pec').valid();
                        var sdiValid = $('#sdi').valid();
                        var businessNameValid = $('#business-name').valid();
                        result = (fiscalCodeValid && vatNumberValid && pecValid && sdiValid && businessNameValid);

                    } else {
                        result = true;
                    }

                    if (result) {
                        var isCustomer = customer.isLoggedIn();

                        var quoteId = quote.getQuoteId();

                        var url;
                        if (isCustomer) {
                            url = urlBuilder.createUrl('/carts/mine/set-invoice', {});
                        } else {
                            url = urlBuilder.createUrl('/guest-carts/:cartId/set-invoice', {cartId: quoteId});
                        }

                        var payload = {
                            cartId: quoteId,
                            invoice: {
                                flag_invoice: $("input[name='custom_attributes[checkout_invoice]']").is(":checked"),
                                fiscal_code: $('#fiscal-code').val(),
                                vat_number: $('#vat-number').val(),
                                business_name: $('#business-name').val(),
                                pec: $('#pec').val(),
                                sdi: $('#sdi').val()
                            }
                        };

                        $.ajax({
                            url: urlFormatter.build(url),
                            data: JSON.stringify(payload),
                            global: false,
                            contentType: 'application/json',
                            type: 'POST',
                            async: false
                        }).done(
                                function (response) {
                                    result = true;
                                }
                        ).fail(
                                function (response) {
                                    result = false;
                                    errorProcessor.process(response);
                                }
                        );
                    }

                    if (!result) {
                        $('html, body').animate({
                            scrollTop: ($("input[name='custom_attributes[checkout_invoice]']").offset().top - 100)
                        }, 500);
                    }

                    return result;

                }
            }
        }
);