define([
	'jquery',
	'Magento_Customer/js/model/customer',
	'Magento_Checkout/js/model/quote',
	'Magento_Checkout/js/model/url-builder',
	'mage/url',
	'Magento_Checkout/js/model/error-processor'
],function($,customer,quote,urlBuilder,urlFormatter,errorProcessor){
	'use strict';
		
	return{
		validate:function(){
			var result = true,
				shippingAddress = quote.shippingAddress(),
				countryId = shippingAddress.countryId,
				postCode = shippingAddress.postcode;

			if(this.validateDni(countryId,postCode)){
				$("#co-payment-form").validation();
				
				if($('#dni').valid()){
					var isCustomer = customer.isLoggedIn(),
						quoteId = quote.getQuoteId(),
						url = isCustomer ? urlBuilder.createUrl('/carts/mine/set-dni',{}) : urlBuilder.createUrl('/guest-carts/:cartId/set-dni',{cartId:quoteId}),
						payload = {
							cartId:quoteId,
							dni:{
								value:$('#dni').val()
							}
						};
	
					$.ajax({
						url:urlFormatter.build(url),
						data:JSON.stringify(payload),
						global:false,
						contentType:'application/json',
						type:'POST',
						async:false
					}).fail(
						function(response){
							result = false;
							errorProcessor.process(response);
						}
					);
				} else{
					result = false;
				}
	
				if(!result && $('.mage-error','#co-payment-form').length == 1) {
					$('html,body').animate({
						scrollTop:$('[name="billingAddress.custom_attributes.dni"').offset().top
					});
				}
			}

			return result;
		},
		validateDni(countryId,postCode){
			if(!((countryId == "ES" && this.checkPostCode(postCode)) || $.inArray(countryId,['IC','EA']) != -1)){
				return false;
			}

			return true;
		},
		checkPostCode:function(postCode){
			return $.isNumeric(postCode) && ((postCode >= 35000 && postCode <= 35999) || (postCode >= 38000 && postCode <= 38999) || (postCode >= 51000 && postCode <= 51999) || (postCode >= 52000 && postCode <= 52999));
		}
	}
});