/**
* Copyright © 2016 Magento. All rights reserved.
* See COPYING.txt for license details.
*/
define([
    'ko',
    'jquery',
    'mage/storage',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/resource-url-manager',
    'Magento_Checkout/js/model/error-processor',
    'Magento_Checkout/js/model/shipping-rate-registry'
], function (ko, $, storage, quote, resourceUrlManager, errorProcessor, rateRegistry) {
    'use strict';

    return function (callbacks, deferred) {

        deferred = deferred || $.Deferred();

        $('.form-cart').on('change', '.input-text.qty', function() {

            $('body').trigger('processStart');

            var form = $(this).parents('form');
            var formAction = $(this).parents('form').attr('action');

            $.ajax({
                url: formAction,
                data: form.serialize(),
                type: 'post',

                success: function(res){
                    $(".cart.items.data.table").replaceWith($('.cart.items.data.table', res));

                    $.when(deferred).done(function () {
                        $('body').trigger('processStop');

                        storage.get(
                            resourceUrlManager.getUrlForCartTotals(quote), false
                        ).done(function (response) {
                            var proceed = true;

                            if (proceed) {
                                quote.setTotals(response);

                                //get address from quote observable
                                var address = quote.shippingAddress();

                                //changes the object so observable sees it as changed
                                address.trigger_reload = new Date().getTime();

                                //create rate registry cache
                                //the two calls are required
                                //because Magento caches things
                                //differently for new and existing
                                //customers (a FFS moment)
                                rateRegistry.set(address.getKey(), null);
                                rateRegistry.set(address.getCacheKey(), null);

                                //with rates cleared, the observable listeners should
                                //update everything when the rates are updated
                                quote.shippingAddress(address);

                                $('body').trigger('processStop');
                            }
                        }).error(function (response) {
                            $('body').trigger('processStop');
                            errorProcessor.process(response);
                        }).always(function () {
                            $('body').trigger('processStop');
                        });
                    });
                }
            });
        })
    }

});
