<?php

namespace FiloBlu\CheckoutExtend\Observer;

use FiloBlu\CheckoutExtend\Helper\RuleHelper;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

class SetOrderCustomerCouponUsage implements ObserverInterface
{
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;
    /**
     * @var RuleHelper
     */
    protected $ruleHelper;

    /**
     * @param OrderRepositoryInterface $orderRepository
     * @param RuleHelper $ruleHelper
     */
    public function __construct(
        OrderRepositoryInterface $orderRepository,
        RuleHelper $ruleHelper
    )
    {
        $this->orderRepository = $orderRepository;
        $this->ruleHelper = $ruleHelper;
    }

    public function execute(Observer $observer)
    {
        $event = $observer->getEvent();
        /** @var CustomerInterface $customer */
        $customer = $event->getData('customer_data_object');
        /** @var array $delegateData */
        $delegateData = $event->getData('delegate_data');
        if (array_key_exists('__sales_assign_order_id', $delegateData)) {
            $orderId = $delegateData['__sales_assign_order_id'];
            $order = $this->orderRepository->get($orderId);
            $this->ruleHelper->addCustomerRule($order, $order->getCustomerId());
        }
    }
}