<?php

namespace FiloBlu\CheckoutExtend\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class LayoutLoadBeforeObserver implements ObserverInterface {

    public $_helper;

    public function __construct(\FiloBlu\CheckoutExtend\Helper\Data $helper) {
        $this->_helper = $helper;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer) {
        $layout = $observer->getData('layout');
        $currentLayoutHandles = $layout->getUpdate()->getHandles();
        
        # move_coupon_into_totals
        if (in_array("checkout_cart_index", $currentLayoutHandles) && $this->_helper->getConfigValue("filoblu_checkoutextend_section/cart/move_coupon_into_totals")) {
            $layout->getUpdate()->addUpdate('<move element="cart.discount" destination="checkout.cart.totals.container" as="cart.discount" after="checkout.cart.totals" />');
        }
        
        # move_coupon_into_totals
        if (in_array("checkout_onepage_success", $currentLayoutHandles) && $this->_helper->getConfigValue("filoblu_checkoutextend_section/registration/enabled")) {
            $layout->getUpdate()->addUpdate('<referenceBlock name="checkout.registration" remove="true"/>');
        }
    }

}
