<?php
namespace FiloBlu\CheckoutExtend\Model;


use FiloBlu\CheckoutExtend\Api\VatServiceInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

/**
 *
 */
class VatService implements VatServiceInterface
{
    /**
     * @var \FiloBlu\CheckoutExtend\Model\Vat
     */
    private $modelVat;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        Vat $modelVat
    ) {
        // TODO: Remove if not needed anymore
        $this->scopeConfig = $scopeConfig;
        $this->modelVat = $modelVat ;
    }

    /**
     * @param string $vatNumber
     * @param string $storeCode
     * @return mixed
     */
    public function getResult( string $vatNumber , string  $storeCode)
    {
        $result= $this->modelVat->checkVatNumber($storeCode,$vatNumber,$this->modelVat->getMerchantCountryCode(), $this->modelVat->getMerchantVatNumber());
        return $result->getIsValid();

    }

}