<?php


namespace FiloBlu\CheckoutExtend\Model\ResourceModel\ShippingCountry;

use FiloBlu\CheckoutExtend\Model\AllowedShippingCountries as AllowedCountries;
use Magento\Framework\App\ObjectManager;
use Magento\Store\Model\ScopeInterface;

/**
 * Country Resource Collection
 *
 * @api
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 * @since 100.0.2
 */
class Collection extends \Magento\Directory\Model\ResourceModel\Country\Collection
{
    /**
     * @var AllowedCountries
     */
    private $allowedCountriesReader;

    /**
     * Return Allowed Countries reader
     *
     * @deprecated 100.1.2
     * @return \Magento\Directory\Model\AllowedCountries
     */
    private function getAllowedCountriesReader()
    {
        if (!$this->allowedCountriesReader) {
            $this->allowedCountriesReader = ObjectManager::getInstance()->get(AllowedCountries::class);
        }

        return $this->allowedCountriesReader;
    }

    /**
     * Load allowed countries for current store
     *
     * @param null|int|string|\Magento\Store\Model\Store $store
     * @return \Magento\Directory\Model\ResourceModel\Country\Collection
     */
    public function loadByStore($store = null)
    {
        $allowedCountries = $this->getAllowedCountriesReader()
            ->getAllowedCountries(ScopeInterface::SCOPE_STORE, $store);

        if (!empty($allowedCountries)) {
            $this->addFieldToFilter("country_id", ['in' => $allowedCountries]);
        }

        return $this;
    }
}
