<?php
/**
 *
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace FiloBlu\CheckoutExtend\Model\Plugin;

/*
 * Load Additional Data when getting Order by OrderRepository 
 */
class OrderGet
{
      
    /** @var \Magento\Sales\Api\Data\OrderExtensionFactory */
    protected $orderExtensionFactory;
    
    /**
     * Init plugin
     *
     * @param \Magento\Sales\Api\Data\OrderExtensionFactory $orderExtensionFactory
     */
    public function __construct(
        \Magento\Sales\Api\Data\OrderExtensionFactory $orderExtensionFactory
    ) {
        $this->orderExtensionFactory = $orderExtensionFactory;
    }

    /**
     * Add Data to order
     *
     * @param \Magento\Sales\Api\OrderRepositoryInterface $subject
     * @param \Magento\Sales\Api\Data\OrderInterface $order
     * @return \Magento\Sales\Api\Data\OrderInterface
     */
    public function afterGet(
        \Magento\Sales\Api\OrderRepositoryInterface $subject,
        \Magento\Sales\Api\Data\OrderInterface $order
    ) {
        $extensionAttributes = $order->getExtensionAttributes();
        $orderExtension = $extensionAttributes ? $extensionAttributes : $this->orderExtensionFactory->create();          
        $orderExtension->setData("checkout_invoice", $order->getData("checkout_invoice")==1);
        $orderExtension->setData("checkout_invoice_vat_number", $order->getData("checkout_invoice_vat_number"));
        $orderExtension->setData("checkout_invoice_fiscal_code", $order->getData("checkout_invoice_fiscal_code"));
        $orderExtension->setData("checkout_invoice_sdi", $order->getData("checkout_invoice_sdi"));
        $orderExtension->setData("checkout_invoice_pec", $order->getData("checkout_invoice_pec"));
		$orderExtension->setData("checkout_invoice_business_name", $order->getData("checkout_invoice_business_name"));
		$orderExtension->setData("dni", $order->getData("dni"));
        $order->setExtensionAttributes($orderExtension);
        return $order;
    }
}
