<?php

namespace FiloBlu\CheckoutExtend\Helper;

use Magento\SalesRule\Model\Rule\CustomerFactory;

class RuleHelper
{
    /**
     * @var CustomerFactory
     */
    protected $ruleCustomerFactory;

    /**
     * @param CustomerFactory $ruleCustomerFactory
     */
    public function __construct(
        CustomerFactory $ruleCustomerFactory
    )
    {
        $this->ruleCustomerFactory = $ruleCustomerFactory;
    }

    /**
     * @param $order
     * @param $customerId
     * @throws Exception
     */
    public function addCustomerRule($order, $customerId)
    {
        if (empty($order->getAppliedRuleIds())) {
            return;
        }

        $rules = explode(',', $order->getAppliedRuleIds());
        if (count($rules)) {
            foreach ($rules as $rule) {
                $this->updateCustomerRuleUsages($customerId, $rule);
            }
        }
    }

    /**
     * @param $customerId
     * @param $ruleId
     * @throws Exception
     */
    public function updateCustomerRuleUsages($customerId, $ruleId)
    {
        $ruleCustomer = $this->ruleCustomerFactory->create();
        $ruleCustomer->loadByCustomerRule($customerId, $ruleId);
        $ruleCustomer->setCustomerId($customerId)->setRuleId($ruleId)->setTimesUsed(1);
        $ruleCustomer->save();
    }
}
