<?php

namespace FiloBlu\CheckoutExtend\Helper;

use Magento\Eav\Model\Config;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Exception\LocalizedException;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * @class Data
 * @package FiloBlu\CheckoutExtend\Helper
 */
class Data extends \Magento\Framework\Url\Helper\Data
{

    /** @var string  */
    const TAX_ID_SSN_ATTRIBUTE_CODE = 'tax_id_ssn';

    /**
     * @var Config
     */
    private $eavConfig;

    /**
     * @param Config $eavConfig
     * @param Context $context
     */
    public function __construct(
        Config $eavConfig,
        Context $context
    ) {
        $this->eavConfig = $eavConfig;
        parent::__construct($context);
    }

    public function getShippingAddressAdditionalData()
    {
        return unserialize($this->scopeConfig->getValue('filoblu_checkoutextend_section/shipping_address/additional_data', ScopeInterface::SCOPE_STORE) ?? '');
    }

    public function getConfigValue($path)
    {
        return $this->scopeConfig->getValue($path, ScopeInterface::SCOPE_STORE);
    }

    public function getCurrentLocale()
    {
        $om = ObjectManager::getInstance();
        $resolver = $om->get('Magento\Framework\Locale\Resolver');
        return $resolver->getLocale();
    }

    public function getCurrentWebsiteName()
    {
        $om = ObjectManager::getInstance();
        return $om->get('Magento\Store\Model\StoreManagerInterface')->getWebsite()->getName();
    }

    /**
     * @return mixed by Erry
     */
    public function getCustomerGroupVatSeparation()
    {
        return $this->scopeConfig->getValue('filoblu_checkoutextend_section/totals/vat_separation', ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return bool
     */
    public function getEnableVatSeparation()
    {
        return (bool)$this->scopeConfig->getValue('filoblu_checkoutextend_section/totals/enabled_vat_separation', ScopeInterface::SCOPE_STORE);
    }

    /**
     * @param $store
     * @return bool
     */
    public function canValidateRequester($store = null)
    {
        return $this->scopeConfig->isSetFlag('filoblu_checkoutextend_section/totals/vat_validate_requester', ScopeInterface::SCOPE_STORE, $store);
    }

    /**
     * @return string
     */
    public function getVatValidationUrl()
    {
        if ($this->_moduleManager->isEnabled('FiloBlu_VatValidatorApi')) {
            return '/vatvalidation/index/validate';
        }

        return '/filoblucheckoutextend/index/validatevat';
    }

    /**
     * @return bool
     * @throws LocalizedException
     */
    public function socialSecurityNumberAttributeExists()
    {
        $attribute = $this->eavConfig->getAttribute(
            'customer_address',
            self::TAX_ID_SSN_ATTRIBUTE_CODE
        );

        if (!$attribute) {
            return false;
        }

        if (!$attribute->getId()) {
            return false;
        }

        return true;
    }

    /**
     * @param string $countryId
     * @return bool
     */
    public function countryIsMexOrUs(string $countryId)
    {
        return in_array($countryId, ['MX', 'US']);
    }
}
