<?php

namespace FiloBlu\CheckoutExtend\Block\Plugin\Checkout;

use Magento\Directory\Helper\Data as DirectoryHelper;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\ObjectManager;

class DirectoryDataProcessor {

    public $_helper;

    /**
     * @var DirectoryHelper
     */
    private $directoryHelper;

    /**
     * @var \FiloBlu\CheckoutExtend\Model\ResourceModel\ShippingCountry\CollectionFactory
     */
    private $countryCollectionFactory;

    /**
     * @var \Magento\Directory\Model\ResourceModel\Country\CollectionFactory
     */
    private $defaultCountryCollectionFactory;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * array
     */
    private $countryOptions;

    public function __construct(
        \FiloBlu\CheckoutExtend\Helper\Data $helper,
        DirectoryHelper $directoryHelper,
        \FiloBlu\CheckoutExtend\Model\ResourceModel\ShippingCountry\CollectionFactory $countryCollection,
        \Magento\Directory\Model\ResourceModel\Country\CollectionFactory $defaultCountryCollection,
        StoreManagerInterface $storeManager = null
) {
        $this->_helper = $helper;
        $this->directoryHelper = $directoryHelper;
        $this->countryCollectionFactory = $countryCollection;
        $this->defaultCountryCollectionFactory = $defaultCountryCollection;
        $this->storeManager = $storeManager ?: ObjectManager::getInstance()->get(StoreManagerInterface::class);
    }

    public function aroundProcess($subject, \Closure $proceed, $jsLayout) {

        if (!isset($jsLayout['components']['checkoutProvider']['dictionariesShipping'])) {
            $jsLayout['components']['checkoutProvider']['dictionariesShipping'] = [
                'country_id' => $this->getCountryOptions()
            ];
        }

        $customJsLayout = $proceed($jsLayout);

        return $customJsLayout;
    }

    /**
     * Get country options list.
     *
     * @return array
     */
    private function getCountryOptions()
    {
        if ($this->_helper->getConfigValue("general/country/enabled_different_shipping_country")) {

            if (!isset($this->countryOptions)) {
                $this->countryOptions = $this->countryCollectionFactory->create()->loadByStore(
                    $this->storeManager->getStore()->getId()
                )->toOptionArray();
                $this->countryOptions = $this->orderCountryOptions($this->countryOptions);
            }
        }
        else {
            if (!isset($this->countryOptions)) {
                $this->countryOptions = $this->defaultCountryCollectionFactory->create()->loadByStore(
                    $this->storeManager->getStore()->getId()
                )->toOptionArray();
                $this->countryOptions = $this->orderCountryOptions($this->countryOptions);
            }
        }


        return $this->countryOptions;
    }

    /**
     * Sort country options by top country codes.
     *
     * @param array $countryOptions
     * @return array
     */
    private function orderCountryOptions(array $countryOptions)
    {
        $topCountryCodes = $this->directoryHelper->getTopCountryCodes();
        if (empty($topCountryCodes)) {
            return $countryOptions;
        }

        $headOptions = [];
        $tailOptions = [[
            'value' => 'delimiter',
            'label' => '──────────',
            'disabled' => true,
        ]];
        foreach ($countryOptions as $countryOption) {
            if (empty($countryOption['value']) || in_array($countryOption['value'], $topCountryCodes)) {
                array_push($headOptions, $countryOption);
            } else {
                array_push($tailOptions, $countryOption);
            }
        }
        return array_merge($headOptions, $tailOptions);
    }

}
