<?php

namespace FiloBlu\CheckoutExtend\Block\Adminhtml\System\Config\Form\Field;

class ShippingAddressAdditionalData extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray {

    protected $_arrayRowsCache;
    
    /**
     * Grid columns
     *
     * @var array
     */
    protected $_columns = [];
    protected $_dataRegionRenderer;

    /**
     * Enable the "Add after" button or not
     *
     * @var bool
     */
    protected $_addAfter = true;

    /**
     * Label of add button
     *
     * @var string
     */
    protected $_addButtonLabel;

    /**
     * Check if columns are defined, set template
     *
     * @return void
     */
    protected function _construct() {
        parent::_construct();
        $this->_addButtonLabel = __('Add');
    }

    /**
     * Returns renderer for country element
     *
     * @return \Magento\Braintree\Block\Adminhtml\Form\Field\Countries
     */
    protected function getDataRegionRenderer() {
        if (!$this->_dataRegionRenderer) {
            $this->_dataRegionRenderer = $this->getLayout()->createBlock(
                    '\FiloBlu\CheckoutExtend\Block\Adminhtml\System\Config\Form\Field\DataRegion', '', ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->_dataRegionRenderer;
    }

    /**
     * Prepare to render
     *
     * @return void
     */
    protected function _prepareToRender() {

        $this->addColumn('input_code', array(
            'label' => __('Input Code'),
            'style' => 'max-width: 100px;',
        ));

        $this->addColumn('data_region', array(
            'label' => __('Data Region'),
            'renderer' => $this->getDataRegionRenderer(),
        ));

        $this->addColumn('label', array(
            'label' => __('Label'),
            'style' => 'max-width: 400px;',
        ));

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    protected function _prepareArrayRow(\Magento\Framework\DataObject $row) {
        
        $dataRegion = $row->getDataRegion();
        $options = [];

        $options['option_' . $this->getDataRegionRenderer()->calcOptionHash($dataRegion)] = 'selected="selected"';

        $row->setData('option_extra_attrs', $options);
    }

    /**
     * Render array cell for prototypeJS template
     *
     * @param string $columnName
     * @return string
     * @throws \Exception
     */
    public function renderCellTemplate($columnName) {
        if ($columnName == "data_region") {
            //            $this->_columns[$columnName]['class'] = 'input-text required-entry validate-number';
            $this->_columns[$columnName]['style'] = 'width:100px;';
        }
        return parent::renderCellTemplate($columnName);
    }

    public function getArrayRows() {
        if (null !== $this->_arrayRowsCache) {
            return $this->_arrayRowsCache;
        }
        $result = [];
        /** @var \Magento\Framework\Data\Form\Element\AbstractElement */
        $element = $this->getElement();

        if ($element->getValue() && !is_array($element->getValue())) {
            $element->setValue(unserialize($element->getValue()));
        }

        if ($element->getValue() && is_array($element->getValue())) {
            foreach ($element->getValue() as $rowId => $row) {
                $rowColumnValues = [];
                foreach ($row as $key => $value) {
                    $row[$key] = $value;
                    $rowColumnValues[$this->_getCellInputElementId($rowId, $key)] = $row[$key];
                }
                $row['_id'] = $rowId;
                $row['column_values'] = $rowColumnValues;
                $result[$rowId] = new \Magento\Framework\DataObject($row);
                $this->_prepareArrayRow($result[$rowId]);
            }
        }
        $this->_arrayRowsCache = $result;
        return $this->_arrayRowsCache;
    }

}
