/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define(
    [
        'jquery',
        'ko',
        'uiComponent',
        'Magento_Checkout/js/model/quote',
        'Magento_SalesRule/js/action/set-coupon-code',
        'Magento_SalesRule/js/action/cancel-coupon',
        'Magento_Checkout/js/model/step-navigator'
    ],
    function ($, ko, Component, quote, setCouponCodeAction, cancelCouponAction, stepNavigator) {
        'use strict';

          var totals = quote.getTotals(),
            couponCode = ko.observable(null);

        if (totals()) {
            couponCode(totals()['coupon_code']);
        }

        var isApplied = ko.observable(couponCode() != false && couponCode() != null);

        return Component.extend({
            defaults: {
                template: 'FiloBlu_CheckoutExtend/payment/discount'
            },
            couponCode: couponCode,

            /**
             * Applied flag
             */
            isApplied: isApplied,

            /**
             * Coupon code application procedure
             */
            apply: function() {
                if (this.validate()) {
                    setCouponCodeAction(couponCode(), isApplied);
                }
            },

            /**
             * Cancel using coupon
             */
            cancel: function() {
                if (this.validate()) {
                    couponCode('');
                    cancelCouponAction(isApplied);
                }
            },

            /**
             * Coupon form validation
             *
             * @returns {Boolean}
             */
            validate: function () {
                var form = '#discount-form';

                return $(form).validation() && $(form).validation('isValid');
            },

            canShow: function () {
                return stepNavigator.isProcessed('shipping');
            }
        });
    }
);
