/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/**
 * @api
 */
define([
    'jquery',
    'ko',
    'Magento_Ui/js/form/element/boolean',
    'underscore',
    'Magento_Checkout/js/model/payment/additional-validators',
    'FiloBlu_CheckoutExtend/js/model/invoice_validator',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/model/cart/totals-processor/default',
    'Magento_Checkout/js/model/cart/cache',
    'mage/validation',
    'jquery/ui',
    'jquery/validate'
], function ($, ko, Element, _, additionalValidators, invoiceValidator, quote,defaultTotal,cartCache) {
    'use strict';

    additionalValidators.registerValidator(invoiceValidator);

    var checkVat = function (pi) {
        if (pi == '') return '';
        if (! /^[0-9]{11}$/.test(pi))
            return "La partita IVA deve contenere 11 cifre.";
        var s = 0;
        for (i = 0; i <= 9; i += 2)
            s += pi.charCodeAt(i) - '0'.charCodeAt(0);
        for (var i = 1; i <= 9; i += 2) {
            var c = 2 * (pi.charCodeAt(i) - '0'.charCodeAt(0));
            if (c > 9) c = c - 9;
            s += c;
        }
        var atteso = (10 - s % 10) % 10;
        if (atteso != pi.charCodeAt(10) - '0'.charCodeAt(0))
            return "La partita IVA non è valida:\n" +
                "il codice di controllo non corrisponde.\n";
        return '';
    };

    var checkFiscalCode = function (cf) {
        cf = cf.toUpperCase();
        if (cf == '') return '';
        if (! /^[0-9A-Z]{16}$/.test(cf))
            return "Il codice fiscale deve contenere 16 tra lettere e cifre.";
        var map = [1, 0, 5, 7, 9, 13, 15, 17, 19, 21, 1, 0, 5, 7, 9, 13, 15, 17,
            19, 21, 2, 4, 18, 20, 11, 3, 6, 8, 12, 14, 16, 10, 22, 25, 24, 23];
        var s = 0;
        for (var i = 0; i < 15; i++) {
            var c = cf.charCodeAt(i);
            if (c < 65)
                c = c - 48;
            else
                c = c - 55;
            if (i % 2 == 0)
                s += map[c];
            else
                s += c < 10 ? c : c - 10;
        }
        var atteso = String.fromCharCode(65 + s % 26);
        if (atteso != cf.charAt(15))
            return "Il codice fiscale non è valido:\n" +
                "il codice di controllo non corrisponde.\n";
        return "";
    };

    return Element.extend({

        initObservable: function () {

            this.isEuropeanCountry = ko.computed(function () {

                var billingAddress = quote.billingAddress();

                if (billingAddress == null || !billingAddress.countryId) {
                    return false;
                }

                if (billingAddress && billingAddress.countryId && window.checkoutConfig.european_union_countries.indexOf(billingAddress.countryId) != -1) {
                    //$("input[name='custom_attributes[checkout_invoice]']").prop('disabled', false);
                    this.disabled(false);
                    return true;
                } else {
                    this.checked(false);
                    this.disabled(true);
                    //$("input[name='custom_attributes[checkout_invoice]']").prop('checked', false);
                    //$("input[name='custom_attributes[checkout_invoice]']").prop('disabled', true);
                    return false;
                }

            }, this);


            this.isPecAndSDIVisible = ko.computed(function () {

                var billingAddress = quote.billingAddress();

                if (billingAddress == null || !billingAddress.countryId) {
                    return false;
                }

                if (billingAddress && billingAddress.countryId && billingAddress.countryId == 'IT') {
                    $(".pec").show();
                    $(".sdi").show();
                    return true;
                } else {
                    $(".pec").hide();
                    $(".pec").val('');
                    $(".sdi").hide();
                    $(".sdi").val('');
                    return false;
                }

            }, this);

            return this._super()
                .observe('checked');
        },

        onElementRender: function () {
            var self = this;

            $.validator.addMethod(
                'validate-required-invoice-fiscal-code-or-vat',
                function (value) {

                    var billingAddress = quote.billingAddress();

                    if (billingAddress && billingAddress.countryId) {
                        return ($('#fiscal-code').val() || $('#vat-number').val());
                    }
                    else {
                        return true;
                    }

                },
                $.mage.__('Fiscal Code Or VAT Number Is Required')
            );

            $.validator.addMethod(
                'validate-fiscal-code',
                function (value) {

                    var billingAddress = quote.billingAddress();

                    if (billingAddress && billingAddress.countryId && billingAddress.countryId == 'IT') {
                        var errorFiscalCode = checkFiscalCode($('#fiscal-code').val());

                        if (errorFiscalCode) {
                            return false
                        }
                        else {
                            return true
                        }

                    }
                    else {
                        return true;
                    }

                },
                $.mage.__('Fiscal Code Not Valid')
            );

            $.validator.addMethod(
                'validate-vat',
                function () {

                    var billingAddress = quote.billingAddress();
                    var vat = $('#vat-number').val();
                    var result = false;

                    if (billingAddress?.countryId) {
                        if (vat || billingAddress.countryId !== 'IT') {
                            $.ajax({
                            type: "POST",
                            url:  '/'+ window.checkoutConfig.storeCode + self.vatValidationUrl,
                            data: {"vat-number": vat , "country-code":billingAddress.countryId},
                            showLoader: true,
                            async: false,
                            dataType: "json"
                            }).done(function (response) {
                                
                                cartCache.set('totals', null);
                                defaultTotal.estimateTotals();

                                if (!response.success) {
                                    result = false;
                                } else {
                                    result = true;
                                }
                            });
                        } else {

                            // In Italy at least fiscal-code or vat-number must be validated.
                            // In that case is admitted to assume that fiscal-code is already validated and vat-number could be empty.
                            if (billingAddress.countryId === 'IT') {
                                result = true;
                            }
                        }
                    }
                    return result
                },
                $.mage.__('VAT Number Not Valid')
            );

            $.validator.addMethod(
                'validate-required-pec-or-sdi-for-it',
                function (value) {

                    if ($('#vat-number').val()) {
                        var billingAddress = quote.billingAddress();

                        if (billingAddress && billingAddress.countryId && billingAddress.countryId == 'IT') {

                            if (!$('#pec').val() && !$('#sdi').val()) {
                                return false;
                            } else {
                                return true;
                            }

                        } else {
                            return true;
                        }
                    }
                    else {
                        return true;
                    }


                },
                $.mage.__('Pec Or SDI Is Required For Italy')
            );

            $.validator.addMethod(
                'validate-required-businessname',
                function (value) {

                    if ($('#vat-number').val()) {

                        if (!$('#business-name').val()) {
                            return false;
                        } else {
                            return true;
                        }

                    }
                    else {
                        return true;
                    }


                },
                $.mage.__('Business Name Is Required')
            );

            /*
            $.validator.addMethod(
                'validate-vat-country',
                function(){
                    var vat = $('#vat-number').val();

                    if(vat && vat.substr(0,2).toLowerCase() != quote.billingAddress().countryId.toLowerCase()){
                        return false;
                    }

                    return true;
                },
                $.mage.__('The first two chars of your VAT must match your billing address country code')
            );
            */

        },

        validate: function () {


            //            if (this.checked()) {
            //
            //                var isValid = true;
            //
            //                var errMsg = "";
            //                if (!$('#fiscal-code').val() && !$('#vat-number').val()) {
            //                    errMsg = "Fiscal Code Or VAT Number Is Required";
            //                    isValid = false;
            //                } else {
            //                    isValid = $("#co-payment-form").valid();
            //                    alert("aa");
            //                }
            //
            //                if (!isValid) {
            //                    this.error(errMsg);
            //                    this.bubble('error', errMsg);
            //                    this.source.set('params.invalid', true);
            //                } else {
            //                    this.error("");
            //                    this.bubble('error', "");
            ////                    this.source.set('params.invalid', false);
            //                }
            //
            //                return {
            //                    valid: isValid,
            //                    target: this
            //                };
            //
            //            } else {
            //                this.error("");
            //                this.bubble('error', "");
            //
            //                return {
            //                    valid: true,
            //                    target: this
            //                };
            //            }


        },
        //        onUpdate: function () {
        //            this.bubble('update', this.hasChanged());
        //
        ////            this.validate();
        //        },
    });
});
