define(
    [
        'jquery',
        'uiComponent',
        'Magento_Checkout/js/model/step-navigator',
        'Magento_Checkout/js/model/quote'
    ],
    function($, Component, stepNavigator, quote) {
        'use strict';
        return Component.extend({
            defaults: {
                template: 'FiloBlu_CheckoutExtend/back-to-cart-block'
            },

            isVisibleBackToCart: function() {
                return !stepNavigator.isProcessed('shipping');
            },
            
            isVisibleBackToShipping: function() {
                return !quote.isVirtual() && stepNavigator.isProcessed('shipping');
            },
            navigateToShipping: function() {
                return stepNavigator.navigateTo('shipping');
            },
            navigateToCart: function(e) {
                window.location = window.checkoutConfig.cartUrl;
                return;
            },

            initialize: function () {
                var self = this;
                this._super();
            }
        });
    }
);