define(
        [
            'uiComponent',
            'jquery',
            'async'
        ],
        function (Component, $, async) {
            'use strict';

            return Component.extend({
                autocomplete: [],

                streetFieldSelector: "input[name='street[0]']",

                fields: {
                    postal_code: {short_name: "input[name='postcode']"},
                    locality: {long_name: "input[name='city']"},
                    postal_town: {short_name: "input[name='city']"},
                    country: {short_name: "select[name='country_id']"},
                    administrative_area_level_1: {long_name: "input[name='region']:visible"},
                    administrative_area_level_2: {short_name: "input[name='region']:visible"}
                },

                initialize: function () {
                    if (window.checkoutConfig.addressAutoComplete.enabled) {
                        async.load(
                                'https://maps.googleapis.com/maps/api/js?key=' + window.checkoutConfig.addressAutoComplete.apiKey + '&libraries=places&callback=initAutocomplete',
                                requirejs,
                                function () {
                                    $(document).on('keypress', this.streetFieldSelector, function (e) {
                                        if (typeof this.autocomplete[e.target.id] === 'undefined') {
                                            var autocomplete = new google.maps.places.Autocomplete(e.target, {types: ['geocode']});
                                            autocomplete.addListener('place_changed', this.fillAddressFields);
                                            autocomplete.e = e.target;
                                            autocomplete.c = this;
                                            this.autocomplete[e.target.id] = autocomplete;
                                        }
                                    }.bind(this));
                                }.bind(this),
                                {isBuild: false}
                        );
                    }
                    return this._super();
                },

                findComponentValue: function (place, type, subtype) {
                    for (var i = 0; i < place.address_components.length; i++) {
                        for (var j = 0; j < place.address_components[i].types.length; j++) {
                            var addressType = place.address_components[i].types[j];
                            if (addressType === type) {
                                return place.address_components[i][subtype];
                            }
                        }
                    }
                    return null;
                },

                fillAddressFields: function () {
                    var place = this.getPlace();
                    if (typeof place === 'undefined') {
                        return;
                    }

                    // reset input field
                    $("input[name='postcode'],input[name='city'],input[name='region'],select[name='region_id'],select[name='country_id']", $(this.e).closest('form')).val("");

                    $(this.e).val(place.name).change();
                    for (var type in this.c.fields) {
                        if (this.c.fields.hasOwnProperty(type)) {
                            for (var subtype in this.c.fields[type]) {
                                if (this.c.fields[type].hasOwnProperty(subtype)) {
                                    var selector = this.c.fields[type][subtype];
                                    var form = $(this.e).closest('form');
                                    var field = form.find(selector);
                                    var value = this.c.findComponentValue(place, type, subtype);
                                    if (value !== null) {
                                        if (field.length) {
                                            try {
                                                field.val(value).change();
                                            } catch (err) {

                                            }

                                        } else if (type === 'administrative_area_level_1') {
                                            // Couldn't find visible region input, dealing with a dropdown.
                                            var regionSelector = "select[name='region_id'] option";
                                            form.find(regionSelector).filter(function () {
                                                return $(this).text() === value;
                                            }).prop('selected', true).change();
                                        } else if (type === 'administrative_area_level_2') {
                                            // Couldn't find visible region input, dealing with a dropdown.
                                            if (window.checkoutConfig.addressAutoComplete.region_options && window.checkoutConfig.addressAutoComplete.region_options.length) {
                                                var currentCountryId = form.find("select[name='country_id']").val();
                                                for (var l = 0; l < window.checkoutConfig.addressAutoComplete.region_options.length; l++) {
                                                    var item = window.checkoutConfig.addressAutoComplete.region_options[l];
                                                    if (item.country_id.toLowerCase() == currentCountryId.toLowerCase() && item.code == value) {
                                                        var regionSelector = "select[name='region_id'] option";
                                                        form.find(regionSelector).filter(function () {
                                                            return $(this).val() === item.value;
                                                        }).prop('selected', true).change();
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            });
        }
);