<?php

namespace FiloBlu\CheckoutExtend\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Newsletter\Model\ResourceModel\Subscriber as SubscriberResource;
use FiloBlu\Newsletter\Model\ResourceModel\SubscriberInfo as SubscriberInfoResource;
use FiloBlu\Newsletter\Model\SubscriberInfoFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;

class SubscriberCheckoutObserver implements ObserverInterface
{
    protected $subscriberResource;
    protected $subscriberInfoResource;
    protected $subscriberInfoFactory;
    protected $storeManagerInterface;
    protected $customerRepository;

    /**
     * @param SubscriberResource $subscriberResource
     * @param SubscriberInfoResource $subscriberInfoResource
     * @param SubscriberInfoFactory $subscriberInfoFactory
     * @param StoreManagerInterface $storeManagerInterface
     * @param CustomerRepositoryInterface $customerRepository
     */
    public function __construct(
        SubscriberResource $subscriberResource,
        SubscriberInfoResource $subscriberInfoResource,
        SubscriberInfoFactory $subscriberInfoFactory,
        StoreManagerInterface $storeManagerInterface,
        CustomerRepositoryInterface $customerRepository
    ) {
        $this->subscriberResource = $subscriberResource;
        $this->subscriberInfoResource = $subscriberInfoResource;
        $this->subscriberInfoFactory = $subscriberInfoFactory;
        $this->storeManagerInterface = $storeManagerInterface;
        $this->customerRepository = $customerRepository;
    }

    /**
     * @param Observer $observer
     * @return void
     * @throws \Magento\Framework\Exception\AlreadyExistsException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function execute(Observer $observer)
    {
        $order = $observer->getData('order');
        if (!$order) {
            return;
        }
        $store = $this->storeManagerInterface->getStore($order->getStoreId());
        $subscriber = $this->subscriberResource->loadByEmail($order->getCustomerEmail());
        $subscriberInfoModel = $this->subscriberInfoFactory->create();
        $shippingAddress = $order->getShippingAddress();

        $subscriberInfoModel->setData([
            'subscriber_id' => $subscriber['subscriber_id'],
            'firstname' => $order->getCustomerFirstname(),
            'lastname' => $order->getCustomerLastname(),
            'source' => 'CHECKOUT',
            'country' => $shippingAddress->getCountryId(),
            'website_name' => $store->getWebsite()->getName(),
            'phone' => $shippingAddress->getTelephone()
        ]);

        $customerId = $order->getCustomerId();

        if (!$customerId) {
            $this->subscriberInfoResource->save($subscriberInfoModel);
            return;
        }
        try {
            $customer = $this->customerRepository->getById($customerId);
            $subscriberInfoModel->addData([
                'dob' => $customer->getDob(),
                'gender' => $customer->getGender(),
            ]);
            $this->subscriberInfoResource->save($subscriberInfoModel);
        } catch (\Exception $e) {
            $this->subscriberInfoResource->save($subscriberInfoModel);
        }
    }
}