<?php
/**
 * Copyright ©  2020 All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace FiloBlu\CheckoutExtend\Observer\Frontend\Sales;

use FiloBlu\CheckoutExtend\Controller\Index\ValidateVat;
use FiloBlu\CheckoutExtend\Helper\Data;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class QuoteCollectTotalsAfter implements ObserverInterface
{

    /**
     * @var Data
     */
    private $helperData;

    private  $validateVat;

    /**
     * QuoteCollectTotalsAfter constructor.
     * @param Data $helperData
     * @param ValidateVat $validateVat
     */
    public function __construct(
        Data $helperData,
        ValidateVat $validateVat
    )
    {
        $this->helperData = $helperData;
        $this->validateVat = $validateVat;
    }

    /***
     * @param Observer $observer
     */
    public function execute(
        Observer $observer
    )
    {
        if(!$this->helperData->getEnableVatSeparation()){
            return;
        }
        $total = $observer->getTotal();
        $vatConfig = $this->helperData->getCustomerGroupVatSeparation();
        $customer = $observer->getQuote()->getCustomer();

        if ($customer->getGroupId() == $vatConfig) {
            if ($total->getAppliedTaxes()) {
                $subtotal = round($total->getSubtotal(),2 ,PHP_ROUND_HALF_UP);
                $taxAmount = round($total->getTotalAmount('tax'),2,PHP_ROUND_HALF_EVEN);
                $mspCodTax = round($total->getMspCodTaxAmount(),2,PHP_ROUND_HALF_EVEN);
                $grandTotalAmount= round($total->getGrandTotal(),2,PHP_ROUND_HALF_EVEN);
                $discountAumount = $total->getBaseDiscountAmount();
                $discountAumountTax = round($total->getBaseDiscountTaxCompensationAmount(),2,PHP_ROUND_HALF_EVEN);

                $mspCodExclTax= round($total->getMspCodAmount() - $total->getMspCodTaxAmount(),2,PHP_ROUND_HALF_EVEN);
                $mspCod= round($total->getMspCashOnDelivery() - $total->getMspCashOnDeliveryTax(),2,PHP_ROUND_HALF_EVEN);

                if ($discountAumount != 0 || $discountAumount != null){

                    $grandTotal = $grandTotalAmount - $taxAmount - $mspCodTax;
                    $total->setBaseDiscountAmount($discountAumount + $discountAumountTax);
                    $total->setDiscountAmount($discountAumount + $discountAumountTax);

                }else{
                    $grandTotal = $subtotal + $total->getShippingAmount() + $mspCodExclTax ;
                }

                if ($mspCodExclTax != null){
                    $total->setMspCodAmount($mspCodExclTax);
                    $total->setMspCodTaxAmount(0);
                    $total->setMspCashOnDelivery($mspCod);
                    $total->setMspCashOnDeliveryTax(0);

                }
                $total->setTotalAmount('subtotal', $grandTotal);
                $total->setBaseTotalAmount('subtotal', $subtotal);
                $total->setTotalAmount('tax',0);
                $total->setBaseTotalAmount('tax', 0);
                $total->setTotalAmount('shipping', round($total->getShippingAmount(),2,PHP_ROUND_HALF_EVEN));
                $total->setBaseTotalAmount('shipping', $total->getShippingAmount());
                $total->setSubtotalInclTax($subtotal);
                $total->setBaseSubtotalInclTax($subtotal);
                $total->setShippingInclTax($total->getShippingAmount());
                $total->setBaseShippingInclTax($total->getShippingAmount());
                $total->setShippingTaxAmount(round($total->getShippingTaxAmount(),2,PHP_ROUND_HALF_EVEN));
                $total->setBaseShippingTaxAmount($total->getBaseShippingTaxAmount());
                $total->setShippingAmountForDiscount($total->getShippingAmount());
                $total->setBaseShippingAmountForDiscount($total->getShippingAmount());
                $total->setBaseTotalAmount('subtotal', $total->getSubtotalInclTax() - $total->getTotalAmount('tax'));
                $total->setGrandTotal($grandTotal);
                $observer->setTotal($total);
                return;
            }
        }

    }
}

