<?php
namespace FiloBlu\CheckoutExtend\Model;


use FiloBlu\CheckoutExtend\Api\VatServiceInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;

class VatService implements VatServiceInterface
{
    
    private  $modelVat ;
    
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        \FiloBlu\CheckoutExtend\Model\Vat $modelVat
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->modelVat = $modelVat ;
    }

    /**
     * @param string $vatNumber
     * @param string $storeCode
     * @return mixed
     */
    public function getResult( string $vatNumber , string  $storeCode)
    {
        $result= $this->modelVat->checkVatNumber($storeCode,$vatNumber,$this->modelVat->getMerchantCountryCode(), $this->modelVat->getMerchantVatNumber());
        return $result->getIsValid();

    }

}