<?php

namespace FiloBlu\CheckoutExtend\Model\Plugin\Checkout;

use FiloBlu\CheckoutExtend\Helper\Data;
use Magento\Checkout\Model\Session;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Quote\Model\QuoteRepository;
use Magento\Checkout\Model\ShippingInformationManagement as ShippingManagement;
use Magento\Checkout\Api\Data\ShippingInformationInterface;

/**
 * @class ShippingInformationManagement
 * @package FiloBlu\CheckoutExtend\Model\Plugin
 */
class ShippingInformationManagement
{

    protected $_helper;
    protected $_quoteRepository;
    protected $_checkoutSession;

    /**
     * @param QuoteRepository $quoteRepository
     * @param Data $helper
     * @param Session $checkoutSession
     */
    public function __construct(
    QuoteRepository $quoteRepository,
    Data $helper,
    Session $checkoutSession
    ) {
        $this->_quoteRepository = $quoteRepository;
        $this->_helper = $helper;
        $this->_checkoutSession = $checkoutSession;
    }

    /**
     * @param ShippingManagement $subject
     * @param $cartId
     * @param ShippingInformationInterface $addressInformation
     * @throws NoSuchEntityException
     * @see \Magento\Checkout\Model\ShippingInformationManagement::saveAddressInformation()
     */
    public function beforeSaveAddressInformation(
        ShippingManagement $subject,
        $cartId,
        ShippingInformationInterface $addressInformation
    )
    {
        $shippingAddress = $addressInformation->getShippingAddress();
        $extensionAttributes = $shippingAddress->getExtensionAttributes();
        $this->_checkoutSession->setRegistrationPwd(null);

        if ($extensionAttributes) {
            $quote = $this->_quoteRepository->getActive($cartId);

            if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/newsletter/enabled")) {
                $newsletterSubscribe = $extensionAttributes->getIsSubscribeForNewsletter() ? 1 : 0;
                $quote->setIsSubscribeForNewsletter($newsletterSubscribe);
            }

            if ($this->_helper->getConfigValue("filoblu_checkoutextend_section/registration/enabled")) {
                $checkoutRegistration = $extensionAttributes->getCheckoutRegistration() ? 1 : 0;
                $quote->setCheckoutRegistration($checkoutRegistration);
                $this->_checkoutSession->setRegistrationPwd($extensionAttributes->getRegistrationPwd());
            }

            $countryId = $addressInformation->getShippingAddress()->getCountryId() ?? '';
            if ($extensionAttributes->getTaxIdSsn() && $this->_helper->countryIsMexOrUs($countryId)) {
                $taxIdSsn = $extensionAttributes->getTaxIdSsn();
                $shippingAddress->setVatId($taxIdSsn);
            }
        }
    }
}
