<?php
namespace FiloBlu\CheckoutExtend\Model;

use Magento\Framework\Exception\CouldNotSaveException;

class InvoiceManagement implements \FiloBlu\CheckoutExtend\Api\InvoiceManagementInterface
{
    protected $quoteRepository;

    public function __construct(
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository
    ) {
        $this->quoteRepository = $quoteRepository;
    }

    /**
     * {@inheritDoc}
     */
    public function saveInvoice(
        $cartId,
        \FiloBlu\CheckoutExtend\Api\Data\InvoiceInterface $invoice
    ) {
        $quote = $this->quoteRepository->getActive($cartId);
        
        $flagInvoice = $invoice->getFlagInvoice();
        $fiscalCode = $invoice->getFiscalCode();
        $vatNumber = $invoice->getVatNumber();
        $businessName = $invoice->getBusinessName();
        $pec = $invoice->getPec();
        $sdi = $invoice->getSdi();

        try {
            $quote->setData('checkout_invoice',$flagInvoice);
            $quote->setData('checkout_invoice_fiscal_code',$fiscalCode);
            $quote->setData('checkout_invoice_vat_number',$vatNumber);
            $quote->setData('checkout_invoice_business_name',$businessName);
            $quote->setData('checkout_invoice_pec',$pec);
            $quote->setData('checkout_invoice_sdi',$sdi);
            $this->quoteRepository->save($quote);
        } catch (\Exception $e) {
            throw new CouldNotSaveException(__($e->getMessage()));
        }

        return $flagInvoice;
    }
    
}
